/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SoundTypeBuilder
extends BaseBuilder<SoundType, SoundTypeBuilder> {
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private ResourceLocation breakSound;
    private ResourceLocation stepSound;
    private ResourceLocation placeSound;
    private ResourceLocation hitSound;
    private ResourceLocation fallSound;

    public static SoundTypeBuilder begin(ThingParser<SoundTypeBuilder> ownerParser, ResourceLocation registryName) {
        return new SoundTypeBuilder(ownerParser, registryName);
    }

    private SoundTypeBuilder(ThingParser<SoundTypeBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setBreakSound(ResourceLocation resourceLocation) {
        this.breakSound = resourceLocation;
    }

    public void setStepSound(ResourceLocation resourceLocation) {
        this.stepSound = resourceLocation;
    }

    public void setHitSound(ResourceLocation resourceLocation) {
        this.hitSound = resourceLocation;
    }

    public void setFallSound(ResourceLocation resourceLocation) {
        this.fallSound = resourceLocation;
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Sound Type";
    }

    @Override
    protected SoundType buildInternal() {
        RegistryObject breakSoundEvent = RegistryObject.create((ResourceLocation)this.breakSound, (IForgeRegistry)ForgeRegistries.SOUND_EVENTS);
        RegistryObject stepSoundEvent = RegistryObject.create((ResourceLocation)this.stepSound, (IForgeRegistry)ForgeRegistries.SOUND_EVENTS);
        RegistryObject placeSoundEvent = RegistryObject.create((ResourceLocation)this.placeSound, (IForgeRegistry)ForgeRegistries.SOUND_EVENTS);
        RegistryObject hitSoundEvent = RegistryObject.create((ResourceLocation)this.hitSound, (IForgeRegistry)ForgeRegistries.SOUND_EVENTS);
        RegistryObject fallSoundEvent = RegistryObject.create((ResourceLocation)this.fallSound, (IForgeRegistry)ForgeRegistries.SOUND_EVENTS);
        return new ForgeSoundType(this.volume, this.pitch, (Supplier)breakSoundEvent, (Supplier)stepSoundEvent, (Supplier)placeSoundEvent, (Supplier)hitSoundEvent, (Supplier)fallSoundEvent);
    }
}

